package com.biz.crm.listener.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.listener.model.TaListenerProcEntity;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;

import java.util.List;

/**
 * 活动节点绑定监听器接口
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
public interface ITaListenerProcService extends IService<TaListenerProcEntity> {

    /**
     * 列表
     * @param taListenerProcReqVo
     * @return PageResult<TaListenerProcRespVo>
     */
    PageResult<TaListenerProcRespVo> findList(TaListenerProcReqVo taListenerProcReqVo);

    /**
     * 查询
     * @param id
     * @return TaListenerProcRespVo
     */
    TaListenerProcRespVo query(String id);

    /**
     * 新增
     * @param taListenerProcReqVos
     * @return
     */
    void save(List<TaListenerProcReqVo> taListenerProcReqVos);

    /**
     * 更新
     * @param taListenerProcReqVos
     */
    void update(List<TaListenerProcReqVo> taListenerProcReqVos);

    /**
     * 删除
     * @param ids id 集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 根据节点查询监听器列表
     * @param taListenerProcReqVo
     * @return
     */
    List<TaListenerQueryVO> queryByNode(TaListenerQueryVO taListenerProcReqVo);
}

