package com.biz.crm.listener.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.listener.mapper.TaListenerMapper;
import com.biz.crm.listener.mapper.TaListenerProcMapper;
import com.biz.crm.listener.model.TaListenerProcEntity;
import com.biz.crm.listener.service.ITaListenerProcService;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 活动节点绑定监听器接口实现
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TaListenerProcServiceExpandImpl")
public class TaListenerProcServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TaListenerProcMapper, TaListenerProcEntity> implements ITaListenerProcService {

    @Resource
    private TaListenerProcMapper taListenerProcMapper;
    @Resource
    private TaListenerMapper taListenerMapper;
    @Autowired
    private ListenerHelper listenerHelper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TaListenerProcRespVo> findList(TaListenerProcReqVo reqVo) {
        Page<TaListenerProcRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TaListenerProcRespVo> list = taListenerProcMapper.findList(page, reqVo);
        return PageResult.<TaListenerProcRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param id
     * @return taListenerProcRespVo
     */
    @Override
    public TaListenerProcRespVo query(String id) {
        TaListenerProcEntity entity = this.taListenerProcMapper.selectById(id);
        if (ObjectUtils.isEmpty(entity)) {
            return CrmBeanUtil.copy(entity, TaListenerProcRespVo.class);
        }
        return null;
    }

    /**
     * 新增
     *
     * @param
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(List<TaListenerProcReqVo> reqVos) {
        reqVos.forEach(reqVo -> {
            //检查参数是否合法
            listenerHelper.procSaveCheck(reqVo);
            TaListenerProcEntity entity = CrmBeanUtil.copy(reqVo, TaListenerProcEntity.class);
            if (StringUtils.isEmpty(reqVo.getId())) {
                this.taListenerProcMapper.insert(entity);
            } else {
                this.taListenerProcMapper.updateById(entity);
            }
        });
    }

    /**
     * 更新
     *
     * @param
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(List<TaListenerProcReqVo> reqVos) {
        reqVos.forEach(reqVo -> {
            //检查参数是否合法
            listenerHelper.procSaveCheck(reqVo);
            TaListenerProcEntity entity = this.getById(reqVo.getId());
            if (ObjectUtils.isNotEmpty(entity)) {
                this.updateById(CrmBeanUtil.copy(reqVo, TaListenerProcEntity.class));
            }
        });
    }

    /**
     * 删除
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        List<String> deleteIds = Lists.newArrayList();
        Set<TaListenerProcEntity> procEntityList = Sets.newHashSet();
        ids.forEach(id->{
            TaListenerProcEntity entity = this.taListenerProcMapper.selectById(id);
            if(ObjectUtils.isNotNull(entity)) {
                procEntityList.add(entity);
                deleteIds.add(id);
            }
        });
        this.taListenerProcMapper.deleteBatchIds(deleteIds);
        //检查删除后监听器是否为空，初始节点是否未挂载默认发起监听器
        TaListenerQueryVO reqVo = new TaListenerQueryVO();
        procEntityList.forEach(pro->{
            reqVo.setNodeCode(pro.getNodeCode());
            reqVo.setProcessVersionKey(pro.getProcessVersionKey());
            List<TaListenerQueryVO> listenerQueryVOS = queryByNode(reqVo);
            AssertUtils.isTrue(CollectionUtil.listNotEmptyNotSizeZero(listenerQueryVOS),"节点至少需要挂载一个监听器！");
//            if(pro.getNodeCode().equals(CommentUtil.DEFAULT_TASK_NODE)){
//                //默认发起节点必须挂载DefaultPositionListener,以确保驳回至发起人能正常执行
//                List<String> listeners  = listenerQueryVOS.stream().map(TaListenerQueryVO::getListenerValue).collect(Collectors.toList());
//                AssertUtils.isTrue(listeners.contains("com.biz.crm.listener.task.DefaultPositionListener"),"默认发起节点必须挂载初始发起监听器");
//            }
        });
    }

    /**
     * 启用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        //设置状态为启用
        List<TaListenerProcEntity> taListenerProcEntities = taListenerProcMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(taListenerProcEntities)) {
            taListenerProcEntities.forEach(o -> {
                o.setListenerState(Indicator.COMMON_ENABLE.getCode());
            });
        }
        this.updateBatchById(taListenerProcEntities);
    }

    /**
     * 禁用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        List<TaListenerProcEntity> taListenerProcEntities = taListenerProcMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(taListenerProcEntities)) {
            taListenerProcEntities.forEach(o -> {
                o.setListenerState(Indicator.COMMON_DISABLE.getCode());
            });
        }
        this.updateBatchById(taListenerProcEntities);
    }

    @Override
    public List<TaListenerQueryVO> queryByNode(TaListenerQueryVO queryVO) {
        Page<TaListenerQueryVO> page = PageUtil.buildPage(queryVO.getPageNum(), queryVO.getPageSize());
        List<TaListenerQueryVO> taListenerQueryVOS = taListenerMapper.queryByNode(page, queryVO);
        taListenerQueryVOS.forEach(taListenerQueryVO -> listenerHelper.convertValue(taListenerQueryVO));
        return taListenerQueryVOS;
    }
}
