package com.biz.crm.listener.task;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.listener.task
 * @Description: 当前职位及其上级职位监听器
 * @date 2021/4/21 下午2:48
 */
@Slf4j
@Component
public class PositionUpListener implements TaskListener {
    @Override
    public void notify(DelegateTask delegateTask) {
        log.info("进入当前职位及其上级职位监听器");
        UserRedis userRedis =  UserUtils.getUser();
        //当前职位信息
        MdmPositionRespVo mdmPositionRespVo =  PositionUtil.getPositionByCode(userRedis.getPoscode());
        //上级职位编码
        String parentCode = mdmPositionRespVo.getParentCode();
        if(StringUtils.isEmpty(parentCode)){
            throw new BusinessException("当前职位【"+mdmPositionRespVo.getPositionName()+"】未找到上级职位编码");
        }
        delegateTask.setAssignee(parentCode);
    }
}
