package com.biz.crm.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 返回前端实体
 *
 * @author YuanZiJian
 * @date 2020/12/15 16:54
 * @version: V1.0
 */
@ApiModel(value = "TaProcessBizRelationRespVo", description = "返回前端业务关系")
@Data
@EqualsAndHashCode(callSuper = false)
public class TaProcessBizRelationRespVo {
    @ApiModelProperty("流程key")
    private String processKey;
    @ApiModelProperty("菜单列表")
    private List<RelationVo> menuList;
    @ApiModelProperty("组织列表")
    private List<RelationVo> orgList;
    @ApiModelProperty(value = "关联单据", required = true)
    private String formParam;
    @ApiModelProperty(value = "选中所有下级，默认为y")
    private String isOnlyCurrentOrg;
}
