/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaTaskCommunicateEntity;
import com.biz.crm.activiti.mapper.TaTaskCommunicateMapper;
import com.biz.crm.activiti.service.ITaTaskCommunicateService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.annotation.Klock;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.ConfirmCommunicateReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskCommunicateReqVO;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taTaskCommunicateService")
public class TaTaskCommunicateServiceImpl
extends ServiceImpl<TaTaskCommunicateMapper, TaTaskCommunicateEntity>
implements ITaTaskCommunicateService {
    @Resource
    private TaTaskCommunicateMapper communicateMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Autowired
    private ActivitiBpmlogService logService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"#reqVO.taskId"}, waitTime=60L, leaseTime=300L)
    public void communicateTo(TaskCommunicateReqVO reqVO) {
        AssertUtils.isNotEmpty((String)reqVO.getTaskId(), (String)"\u4efb\u52a1id[taskId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVO.getContent(), (String)"\u6c9f\u901a\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)reqVO.getTargetUserNames(), (String)"\u6c9f\u901a\u76ee\u6807\u7528\u6237[targetUserCodes]\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isTrue((reqVO.getTargetUserNames().size() == Sets.newHashSet((Iterable)reqVO.getTargetUserNames()).size() ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u7528\u6237");
        Task task = this.helper.findCurrentTaskByTaskId(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c");
        ActivitiBusinessEntity businessEntity = this.helper.findActivitiBusinessEntityByInstanceId(task.getProcessInstanceId());
        UserRedis currentUser = UserUtils.getUser();
        List<MdmUserPageRespVo> users = this.helper.findUsersByCodeList(reqVO.getTargetUserNames());
        List communicateEntities = users.stream().map(user -> {
            TaTaskCommunicateEntity communicate = new TaTaskCommunicateEntity();
            communicate.setContent(reqVO.getContent());
            communicate.setTargetUserCode(user.getUserName());
            communicate.setTargetUserName(user.getFullName());
            communicate.setTargetPosCode(user.getPositionCode());
            communicate.setTargetPosName(user.getPositionName());
            communicate.setTargetOrgCode(user.getOrgCode());
            communicate.setTargetOrgName(user.getOrgName());
            communicate.setProcessInstanceId(task.getProcessInstanceId());
            communicate.setCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
            communicate.setTaskId(reqVO.getTaskId());
            communicate.setTaskDefKey(task.getTaskDefinitionKey());
            communicate.setTaskName(task.getName());
            communicate.setStatus(Integer.valueOf(Indicator.COPY_TASK_STATUS_UNREAD.getCode()));
            communicate.setIsNeedReply(Optional.ofNullable(reqVO.getIsNeedReply()).orElse(GlobalWhetherEnum.NO.getCode()));
            return communicate;
        }).collect(Collectors.toList());
        this.saveBatch(communicateEntities);
        TaNodeConfigEntity nodeConfigEntity = this.helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), task.getTaskDefinitionKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder().businessId(businessEntity.getBusinessId()).businessNo(businessEntity.getBusinessNo()).crmProcessInstanceId(businessEntity.getCrmProcessInstanceId()).operateType(ActivitiOperateTypeEnum.COMMUNICATE.getCode()).taskId(reqVO.getTaskId()).processInstanceId(task.getProcessInstanceId()).nodeName(task.getName()).nodeCode(task.getTaskDefinitionKey()).nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId() : null).build();
        bpmlogVo.setRemarks(this.helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.COMMUNICATE.getCode(), currentUser.getPoscode(), false));
        this.logService.commomSaveLog(bpmlogVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"#reqVO.communicateId"}, waitTime=60L, leaseTime=300L)
    public void confirmCommunicate(ConfirmCommunicateReqVO reqVO) {
        AssertUtils.isNotEmpty((String)reqVO.getCommunicateId(), (String)"\u6c9f\u901a\u4efb\u52a1id[communicateId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVO.getContent(), (String)"\u6c9f\u901a\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a");
        TaTaskCommunicateEntity taTaskCommunicateEntity = (TaTaskCommunicateEntity)this.communicateMapper.selectById((Serializable)((Object)reqVO.getCommunicateId()));
        AssertUtils.isNotNull((Object)taTaskCommunicateEntity, (String)"\u6c9f\u901a\u4efb\u52a1\u4e0d\u5b58\u5728");
        if (Objects.equals(Indicator.COPY_TASK_STATUS_READ.getCode(), taTaskCommunicateEntity.getStatus())) {
            return;
        }
        UserRedis user = UserUtils.getUser();
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)user.getUsername(), (CharSequence)taTaskCommunicateEntity.getTargetUserCode()), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u786e\u8ba4\u6c9f\u901a\u7684\u6743\u9650");
        taTaskCommunicateEntity.setStatus(Integer.valueOf(Indicator.COPY_TASK_STATUS_READ.getCode()));
        this.updateById(taTaskCommunicateEntity);
        ActivitiBusinessEntity businessEntity = this.helper.findActivitiBusinessEntityByInstanceId(taTaskCommunicateEntity.getProcessInstanceId());
        TaNodeConfigEntity nodeConfigEntity = this.helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), taTaskCommunicateEntity.getTaskDefKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder().businessId(businessEntity.getBusinessId()).businessNo(businessEntity.getBusinessNo()).crmProcessInstanceId(businessEntity.getCrmProcessInstanceId()).operateType(ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode()).taskId(reqVO.getCommunicateId()).processInstanceId(businessEntity.getProcessInstanceId()).nodeName(nodeConfigEntity.getProcessNodeName()).nodeCode(taTaskCommunicateEntity.getTaskDefKey()).nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId() : null).build();
        bpmlogVo.setRemarks(this.helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode(), user.getPoscode(), false));
        bpmlogVo.setContent(reqVO.getContent());
        this.logService.commomSaveLog(bpmlogVo);
    }
}

