/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.config.MyIdGenerator;
import javax.sql.DataSource;
import org.activiti.engine.DynamicBpmnService;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class ActivitiConfig {
    @Value(value="${spring.datasource.driverClassName:mysql}")
    private String datasourceFlag;
    @Value(value="${spring.datasource.druid.username:}")
    private String databaseSchema;
    @Value(value="${activiti-mail.mail-server-open-flag}")
    private boolean mailServerOpenFlag;
    @Value(value="${activiti-mail.mail-server-host}")
    private String mailServerHost;
    @Value(value="${activiti-mail.mail-server-port}")
    private int mailServerPort;
    @Value(value="${activiti-mail.mail-server-default-from}")
    private String mailServerDefaultFrom;
    @Value(value="${activiti-mail.mail-server-user-name}")
    private String mailServerUserName;
    @Value(value="${activiti-mail.mail-server-password}")
    private String mailServerPassword;
    @Value(value="${activiti-mail.mail-server-use-ssl}")
    private boolean mailServerUseSsl;

    @Bean
    public ProcessEngineConfiguration processEngineConfiguration(DataSource dataSource, PlatformTransactionManager transactionManager) {
        SpringProcessEngineConfiguration processEngineConfiguration = new SpringProcessEngineConfiguration();
        processEngineConfiguration.setDataSource(dataSource);
        processEngineConfiguration.setDatabaseSchemaUpdate("true");
        if (this.datasourceFlag.toLowerCase().contains("mysql")) {
            processEngineConfiguration.setDatabaseType("mysql");
        } else {
            processEngineConfiguration.setDatabaseSchema(this.databaseSchema);
            processEngineConfiguration.setDatabaseType("oracle");
        }
        processEngineConfiguration.setIdGenerator((IdGenerator)new MyIdGenerator());
        processEngineConfiguration.setTransactionManager(transactionManager);
        processEngineConfiguration.setActivityFontName("\u5b8b\u4f53");
        processEngineConfiguration.setAnnotationFontName("\u5b8b\u4f53");
        processEngineConfiguration.setLabelFontName("\u5b8b\u4f53");
        if (this.mailServerOpenFlag) {
            processEngineConfiguration.setMailServerHost(this.mailServerHost);
            processEngineConfiguration.setMailServerPort(this.mailServerPort);
            processEngineConfiguration.setMailServerDefaultFrom(this.mailServerDefaultFrom);
            processEngineConfiguration.setMailServerUsername(this.mailServerUserName);
            processEngineConfiguration.setMailServerPassword(this.mailServerPassword);
            processEngineConfiguration.setMailServerUseSSL(this.mailServerUseSsl);
        }
        return processEngineConfiguration;
    }

    @Bean
    public ProcessEngineFactoryBean processEngine(ProcessEngineConfiguration processEngineConfiguration) {
        ProcessEngineFactoryBean processEngineFactoryBean = new ProcessEngineFactoryBean();
        processEngineFactoryBean.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)processEngineConfiguration);
        return processEngineFactoryBean;
    }

    @Bean
    public RepositoryService repositoryService(ProcessEngine processEngine) {
        return processEngine.getRepositoryService();
    }

    @Bean
    public RuntimeService runtimeService(ProcessEngine processEngine) {
        return processEngine.getRuntimeService();
    }

    @Bean
    public TaskService taskService(ProcessEngine processEngine) {
        return processEngine.getTaskService();
    }

    @Bean
    public HistoryService historyService(ProcessEngine processEngine) {
        return processEngine.getHistoryService();
    }

    @Bean
    public FormService formService(ProcessEngine processEngine) {
        return processEngine.getFormService();
    }

    @Bean
    public IdentityService identityService(ProcessEngine processEngine) {
        return processEngine.getIdentityService();
    }

    @Bean
    public ManagementService managementService(ProcessEngine processEngine) {
        return processEngine.getManagementService();
    }

    @Bean
    public DynamicBpmnService dynamicBpmnService(ProcessEngine processEngine) {
        return processEngine.getDynamicBpmnService();
    }
}

