package com.biz.crm.nebular.dms.contract;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "合同文件的vo")
@SaturnEntity(name = "ContractFileVo", description = "合同文件")
@SaturnDomain(value = "contractfile")
public class ContractFileVo {

    @ApiModelProperty(value = "合同ID")
    @SaturnColumn(description = "合同ID")
    private String contractId;

    @ApiModelProperty(value = "原文件名")
    @SaturnColumn(description = "原文件名")
    private String originalFileName;

    @ApiModelProperty(value = "文件objectName")
    @SaturnColumn(description = "文件objectName")
    private String objectName;

    @ApiModelProperty(value = "文件地址")
    @SaturnColumn(description = "文件地址")
    private String url;

    @ApiModelProperty(value = "文件显示顺序")
    @SaturnColumn(description = "文件显示顺序")
    private Integer sortNum;
}
