package com.biz.crm.nebular.dms.promotion;


import com.biz.crm.nebular.mdm.CrmExtEditVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 促销政策详细信息VO
 *  @author: luoqi
 *  @Date: 2020-10-21 11:08
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策详细信息VO")
public class PromotionPolicyInfoVo extends CrmExtEditVo implements Serializable {
    /**
     * 促销编码
     */
    @ApiModelProperty(value = "促销编码")
    private String promotionPolicyCode;

    /**
     * 促销名称
     */
    @ApiModelProperty(value = "促销名称")
    private String promotionPolicyName;

    /**
     * 促销政策模板模板id
     */
    @ApiModelProperty(value = "促销政策模板模板id")
    private String templateId;

    /**
     * 促销政策模板模板code
     */
    @ApiModelProperty(value = "促销政策模板模板code")
    private String templateCode;

    /**
     * 促销政策模板模板name
     */
    @ApiModelProperty(value = "促销政策模板模板name")
    private String templateName;

    /**
     * 有效期开始
     */
    @ApiModelProperty(value = "有效期开始")
    private Long beginTime;

    /**
     * 有效期结束
     */
    @ApiModelProperty(value = "有效期结束")
    private Long endTime;
    /**
     * 计算该政策是否在有效期内
     * 3个业务状态， 待执行：null，执行中：true，已结束：false
     *  @author: luoqi
     *  @Date: 2020-10-19 15:40
     *  @version: V1.0
     *  @Description:
     */
    public Boolean timeActive(){
        if(null == this.beginTime || null == this.endTime){
            return true;
        }
        long now = System.currentTimeMillis();
        if(now > this.beginTime){
            return null;
        }
        return now > this.beginTime && now < this.endTime;
    }

    /**
     * 政策叠加
     */
    @ApiModelProperty(value = "政策叠加")
    private String multipleable;

    /**
     * 首单享受
     */
    @ApiModelProperty(value = "首单享受")
    private String firstOrder;

    /**
     * 促销描述
     */
    @ApiModelProperty(value = "促销描述")
    private String description;

    /**
     * 商品组合起订量
     */
    @ApiModelProperty(value = "商品组合起订量")
    private String productsOrderQty;

    /**
     * 组合起订量类型
     */
    @ApiModelProperty(value = "组合起订量类型")
    private String productsOrderQtyType;
}
