package com.biz.crm.nebular.dms.promotion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 促销商品编辑页面VO
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销商品编辑页面VO")
public class PromotionPolicyProductEditVo implements Serializable {
    @ApiModelProperty(value = "id")
    private String id;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String productCode;


    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String productName;

    /**
     * 本品赠品
     */
    @ApiModelProperty(value = "本品赠品")
    private String currentProduct;

    /**
     * 单品起订量类型
     */
    @ApiModelProperty(value = "单品起订量类型")
    private String productOrderQtyType;

    /**
     * 单品起订量
     */
    @ApiModelProperty(value = "单品起订量")
    private BigDecimal productOrderQty;


    /**
     * 政策id
     */
    @ApiModelProperty(value = "政策id")
    private String promotionPolicyId;

    /**
     * 政策code
     */
    @ApiModelProperty(value = "政策code")
    private String promotionPolicyCode;

    /**
     * 政策名称
     */
    @ApiModelProperty(value = "政策名称")
    private String promotionPolicyName;

}
