package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.nebular.mdm.CrmExtEditVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 促销政策模板
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策模板编辑页面VO")
@SaturnEntity(name = "PromotionPolicyTemplateEditVo", description = "促销政策模板编辑页面VO")
public class PromotionPolicyTemplateEditVo extends CrmExtEditVo {
    /**
     * 模板名称
     */
    @ApiModelProperty(value = "模板名称")
    @SaturnColumn(description = "模板名称")
    private String templateName;
    /**
     * 模板编码
     */
    @ApiModelProperty(value = "模板编码")
    @SaturnColumn(description = "模板编码")
    private String templateCode;

    /**
     * 促销类型
     */
    @ApiModelProperty(value = "促销类型")
    @SaturnColumn(description = "促销类型")
    private String promotionType;

    /**
     * 促销商品
     */
    @ApiModelProperty(value = "促销商品")
    @SaturnColumn(description = "促销商品")
    private String promotionProduct;

    /**
     * 是否阶梯
     */
    @ApiModelProperty(value = "是否阶梯")
    @SaturnColumn(description = "是否阶梯")
    private String ladderable;

    /**
     * 首单优惠
     */
    @ApiModelProperty(value = "首单优惠")
    @SaturnColumn(description = "首单优惠")
    private String firstOrder;


    /**
     * 条件规则
     */
    @ApiModelProperty(value = "条件规则")
    @SaturnColumn(description = "条件规则")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionRuleSelectionVo> condition;
    /**
     * 限量规则
     */
    @ApiModelProperty(value = "限量规则")
    @SaturnColumn(description = "限量规则")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionRuleSelectionVo> limited;
    /**
     * 计算规则
     */
    @ApiModelProperty(value = "计算规则")
    @SaturnColumn(description = "计算规则")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionRuleSelectionVo> calculate;

    @JsonIgnore
    @SaturnColumn(description = "全量规则")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionRuleSelectionVo> all = null;

    public List<PromotionRuleSelectionVo> takeAllRule(){
        if(null == all){
            all = Lists.newArrayList();
            if(null != calculate){
                all.addAll(calculate);
            }
            if(null != condition){
                all.addAll(condition);
            }
            if(null != limited){
                all.addAll(limited);
            }
        }
        return all;
    }

}
