package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;


/**
 * 促销规则
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销规则vo")
public class PromotionRuleVo extends CrmBaseVo {
    public enum RULE_TYPE{
        /**
         * 条件规则
         */
        condition,
        /**
         * 限量规则
         */
        limited,
        /**
         * 计算规则
         */
        calculate
    }
    public enum PROMOTION_TYPE{
        /**
         * 默认占位符(限量规则没有 促销类型，使用该占位符作为默认值)
         */
        def,
        /**
         * 买赠
         */
        buy_free,
        /**
         * 满减
         */
        over_minus,
        /**
         * 打折
         */
        discount,
        /**
         * 特价
         */
        special_offer
    }
    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称")
    @SaturnColumn(description = "规则名称")
//    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private String ruleName;

    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码")
    @SaturnColumn(description = "规则编码")
    private String ruleCode;

    /**
     * 规则类型
     */
    @ApiModelProperty(value = "规则类型")
    @SaturnColumn(description = "规则类型")
    private String ruleType;

    /**
     * 促销类型
     */
    @ApiModelProperty(value = "促销类型")
    @SaturnColumn(description = "促销类型")
    private String promotionType;

    /**
     * 函数体
     */
    @ApiModelProperty(value = "函数体")
    @SaturnColumn(description = "函数体")
    private String funcBody;


    /**
     * 调试参数
     */
    @ApiModelProperty(value = "调试参数")
    @SaturnColumn(description = "调试参数")
    private String testJsonParams;




}
