package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmCustomerMsgReqVo", description = "客户信息请求")
@Accessors(chain = true)
public class MdmCustomerMsgReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户组织")
    private String customerOrgName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("操作类型")
    private String operateType;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织")
    private String orgName;

    @ApiModelProperty("市级编码")
    private String cityCode;

    @ApiModelProperty("区级编码")
    private String districtCode;

    @ApiModelProperty("省级编码")
    private String provinceCode;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("工程名")
    private String projectName;

    @ApiModelProperty("客户联系方式")
    private String customerContact;

    @ApiModelProperty("客户法人代表")
    private String legalRepresentative;

    @ApiModelProperty("对接人列表")
    private List<MdmCustomerDockingReqVo> mdmCustomerDockingVos;

    @ApiModelProperty("联系人列表")
    private List<MdmCustomerContactReqVo> mdmCustomerContactVos;

}