package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Data
@ApiModel(value = "客户信息：关联终端")
@SaturnEntity(name = "MdmCustomerTerminalRespVo", description = "客户信息：关联终端")
public class MdmCustomerTerminalRespVo extends CrmBaseVo {

    @ApiModelProperty("客户id")
    @SaturnColumn(description = "客户id")
    private String customerId;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端类型")
    private String terminalTypeCode;

    @ApiModelProperty("终端类型名称")
    private String terminalTypeName;

    @ApiModelProperty("终端地址")
    private String terminalAddr;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称")
    private String orgName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;
}