package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 描述业务系统中的组织机构信息请求vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineOrgReqVo", description = "描述业务系统中的组织机构信息")
public class EngineOrgReqVo extends CrmTreeVo {

    @ApiModelProperty("id集合")
    private List<String> ids;

    @ApiModelProperty("组织机构唯一编号")
    private String orgCode;

    @ApiModelProperty("组织机构描述")
    private String orgDesc;

    @ApiModelProperty("组织机构名称")
    private String orgName;

    @ApiModelProperty("组织机构类型")
    private Integer orgType;

    @ApiModelProperty("父级组织")
    private String parentId;

    @ApiModelProperty("组织机构所在层级")
    private String orgLevel;

}