package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 组织树响应
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织树响应")
@SaturnEntity(name = "EngineOrgTreeRespVo", description = "组织树响应")
public class EngineOrgTreeRespVo {

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("组织机构唯一编号")
    @SaturnColumn(description = "组织机构唯一编号")
    private String orgCode;

    @ApiModelProperty("组织机构名称")
    @SaturnColumn(description = "组织机构名称")
    private String orgName;

    @ApiModelProperty("父级组织")
    @SaturnColumn(description = "父级组织")
    private String parentId;

    @ApiModelProperty("层级")
    @SaturnColumn(description = "层级")
    private Integer level;

    @ApiModelProperty("组织机构所在层级")
    @SaturnColumn(description = "组织机构所在层级")
    private String orgLevel;

    @ApiModelProperty("下级组织")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "下级组织")
    private List<EngineOrgTreeRespVo> children;

}