package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Set;

/**
 * 职位存储信息
 *
 * @author zxw
 * @date 2020-10-23 14:14
 **/
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@ApiModel("职位存储信息")
public class EnginePositionStoreVo {

    private String id;
    @SaturnColumn(description = "岗位的唯一编号", length = 128, nullable = false, unique = true)
    private String code;
    @SaturnColumn(description = "岗位名称", length = 64, nullable = false)
    private String name;
    @SaturnColumn(description = "所属组织id", nullable = true)
    private EngineOrgStoreVo organization;
    @SaturnColumn(description = "岗位父级")
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.ManyToOne)
    private EnginePositionStoreVo parent;
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description="岗位的子级")
    private Set<EnginePositionStoreVo> children;
}
