package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户列表分页查询入参
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineUserPageReqVo", description = "用户列表分页查询入参")
public class EngineUserPageReqVo extends CrmBaseVo {

    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("用户账号登录信息")
    private String userAccount;

    @ApiModelProperty("用户类型:u企业用户，c客户用户,数据字典user_type")
    private String userType;

    @ApiModelProperty("关联客户编码")
    private String customerCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("权限角色编码")
    private String roleCode;

    @ApiModelProperty("上级用户名称")
    private String parentUserName;

    @ApiModelProperty("人员姓名")
    private String userName;

    @ApiModelProperty("组织编码")
    private String orgCode;

}