package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户职位列表
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineUserPositionVo", description = "用户职位列表")
@SaturnEntity(name = "EngineUserPositionVo", description = "用户职位列表")
public class EngineUserPositionVo {

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private short positionName;

    @ApiModelProperty("上级职位id")
    @SaturnColumn(description = "上级职位id")
    private String parentPositionId;

    @ApiModelProperty("上级职位名称")
    @SaturnColumn(description = "上级职位名称")
    private String parentPositionName;

    @ApiModelProperty("操作类型,新建职位n，已有职位h，数据字典position_operation")
    @SaturnColumn(description = "操作类型,新建职位n，已有职位h，数据字典position_operation")
    private String operationType;

    @ApiModelProperty("操作类型,新建职位n，已有职位h，数据字典position_operation")
    @SaturnColumn(description = "操作类型,新建职位n，已有职位h，数据字典position_operation")
    @CrmDict(typeCode = DictConstant.POSITION_OPERATION, dictCodeField = "operationType")
    private String operationTypeName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    @SaturnColumn(description = "职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("是否主职位,y是n否,数据字典position_primary")
    @SaturnColumn(description = "是否主职位,y是n否,数据字典position_primary")
    private Integer isPrimary;

    @ApiModelProperty("流程角色列表")
    @SaturnColumn(description = "流程角色列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> processRuleCodeList;

    @ApiModelProperty("权限角色编码列表")
    @SaturnColumn(description = "权限角色编码列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> roleCodeList;

}