package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户新增入参
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineUserViewVo", description = "用户新增入参")
@SaturnEntity(name = "EngineUserViewVo", description = "用户职位列表")
public class EngineUserViewVo extends CrmBaseVo{

    @ApiModelProperty("用户账号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @ApiModelProperty("用户编码")
    @SaturnColumn(description = "用户编码")
    private String userCode;

    @ApiModelProperty("性别1男 2女")
    @SaturnColumn(description = "性别")
    private Integer gender;

    @ApiModelProperty("用户账号密码")
    @SaturnColumn(description = "密码")
    private String userPassword;

    @ApiModelProperty("人员主要联系电话(也可能会使用该信息登录)")
    @SaturnColumn(description = "电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "姓名")
    private String userName;

    @ApiModelProperty("邮箱")
    @SaturnColumn(description = "邮箱")
    private String email;

    @ApiModelProperty("生效时间")
    @SaturnColumn(description = "生效时间")
    private String startTime;

    @ApiModelProperty("失效时间")
    @SaturnColumn(description = "失效时间")
    private String endTime;

    @ApiModelProperty("用户类型:u企业用户，c客户用户,数据字典user_type")
    @SaturnColumn(description = "用户类型:u企业用户，c客户用户,数据字典user_type")
    private String userType;

    @ApiModelProperty("用户类型:u企业用户，c客户用户,数据字典user_type")
    @SaturnColumn(description = "用户类型:u企业用户，c客户用户,数据字典user_type")
    @CrmDict(typeCode = DictConstant.USER_TYPE,dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("职位列表")
    @SaturnColumn(description = "职位列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<EngineUserPositionVo> engineUserPositionVos;

    @ApiModelProperty("客户列表")
    @SaturnColumn(description = "客户列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<EngineUserCustomerVo> engineUserCustomerVos;

    @ApiModelProperty("扩展字段1")
    @SaturnColumn(description = "扩展字段1")
    private String extend1;
    @ApiModelProperty("扩展字段2")
    @SaturnColumn(description = "扩展字段2")
    private String extend2;
    @ApiModelProperty("扩展字段3")
    @SaturnColumn(description = "扩展字段3")
    private String extend3;
    @ApiModelProperty("扩展字段4")
    @SaturnColumn(description = "扩展字段4")
    private String extend4;
    @ApiModelProperty("扩展字段5")
    @SaturnColumn(description = "扩展字段5")
    private String extend5;
    @ApiModelProperty("扩展字段6")
    @SaturnColumn(description = "扩展字段6")
    private String extend6;
    @ApiModelProperty("扩展字段7")
    @SaturnColumn(description = "扩展字段7")
    private String extend7;
    @ApiModelProperty("扩展字段8")
    @SaturnColumn(description = "扩展字段8")
    private String extend8;
    @ApiModelProperty("扩展字段9")
    @SaturnColumn(description = "扩展字段9")
    private String extend9;
    @ApiModelProperty("扩展字段10")
    @SaturnColumn(description = "扩展字段10")
    private String extend10;

    /*---------------------------------EngineUserPositionVo字段-前端配置表单-请勿随意使用---------------------------------*/
    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private short positionName;

    @ApiModelProperty("上级职位id")
    @SaturnColumn(description = "上级职位id")
    private String parentPositionId;

    @ApiModelProperty("上级职位名称")
    @SaturnColumn(description = "上级职位名称")
    private String parentPositionName;

    @ApiModelProperty("操作类型,新建职位n，已有职位h，数据字典position_operation")
    @SaturnColumn(description = "操作类型,新建职位n，已有职位h，数据字典position_operation")
    private String operationType;

    @ApiModelProperty("操作类型,新建职位n，已有职位h，数据字典position_operation")
    @SaturnColumn(description = "操作类型,新建职位n，已有职位h，数据字典position_operation")
    @CrmDict(typeCode = DictConstant.POSITION_OPERATION, dictCodeField = "operationType")
    private String operationTypeName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    @SaturnColumn(description = "职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("是否主职位,y是n否,数据字典position_primary")
    @SaturnColumn(description = "是否主职位,y是n否,数据字典position_primary")
    private Integer isPrimary;

    @ApiModelProperty("流程角色列表")
    @SaturnColumn(description = "流程角色列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> processRuleCodeList;

    @ApiModelProperty("权限角色编码列表")
    @SaturnColumn(description = "权限角色编码列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> roleCodeList;
    /*---------------------------------前端配置表单使用---------------------------------*/

}