package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 用户关联客户分页查询
 *
 * @author zxw
 * @date 2020-10-10 10:22
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationCustomerPageReqVo", description = "用户关联客户分页查询请求")
public class MdmUserRelationCustomerPageReqVo extends PageVo {

    @ApiModelProperty("查询类型(1:未关联任何用户的客户，2:未关联当前用户的客户,3:已关联任何用户的客户)")
    @NotBlank(message = "查询类型不能为空")
    private String queryType;

    @ApiModelProperty("用户帐号")
    @NotBlank(message = "用户帐号不能为空")
    private String userAccount;

    @ApiModelProperty("客户编码或名称")
    private String customerCodeOrName;

    @ApiModelProperty("客户类型")
    private String customerType;
}
