package com.biz.crm.nebular.mdm.priceconditiongroup.req;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import java.util.Map;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 条件字段分类主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceConditionGroupReqVo", description = "条件字段分类主表 ")
public class MdmPriceConditionGroupReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("条件字段分类描述")
    private String conditionGroupDesc;

    @ApiModelProperty("条件编码组合key(校验编码维度不能重复用)")
    private String groupCodesKey;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "条件字段键值对集合")
    private List<MdmPriceConditionGroupRelFieldReqVo> conditionFieldList;

}