package com.biz.crm.nebular.mdm.region;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 行政区域信息返回vo
 *
 * @author zxw
 * @date 2020-09-29 10:35:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "行政区域信息")
@SaturnEntity(name = "EngineAdministrativeRegionRespVo", description = "行政区域信息")
public class EngineAdministrativeRegionRespVo extends CrmExtVo {

    @ApiModelProperty("降维编码")
    @SaturnColumn(description = "降维编码")
    private String dimensionalityCode;

    @ApiModelProperty("邮编")
    @SaturnColumn(description = "邮编")
    private String email;

    @ApiModelProperty("纬度")
    @SaturnColumn(description = "纬度")
    private String latitude;

    @ApiModelProperty("经度")
    @SaturnColumn(description = "经度")
    private String longitude;

    @ApiModelProperty("区域编码")
    @SaturnColumn(description = "区域编码")
    private String regionCode;

    @ApiModelProperty("区域层级")
    @SaturnColumn(description = "区域层级")
    private String regionLevel;

    @ApiModelProperty("区域名称")
    @SaturnColumn(description = "区域名称")
    private String regionName;

    @ApiModelProperty("上级id")
    @SaturnColumn(description = "上级id")
    private String parentId;

}