package com.biz.crm.nebular.mdm.role.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 用户-客户关联：关联客户入参
 *
 * @author zxw
 * @date 2020-10-09 18:51
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmRoleRelationPositionReqVo", description = "角色-职位关联：关联职位入参")
public class MdmRoleRelationPositionReqVo {

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("职位编码集合")
    private List<String> positionCodeList;
}
