package com.biz.crm.nebular.mdm.role.resp;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位关联角色分页查询响应
 *
 * @author zxw
 * @date 2020-10-12 10:04
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmRoleRelationPositionPageRespVo", description = "职位关联角色分页查询响应")
@SaturnEntity(name = "MdmRoleRelationPositionPageRespVo", description = "职位关联角色分页查询响应")
public class MdmRoleRelationPositionPageRespVo extends PageVo {

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @ApiModelProperty("用户名称")
    @SaturnColumn(description = "用户名称")
    private String userName;

    @ApiModelProperty("上级职位id")
    @SaturnColumn(description = "上级职位id")
    private String parentPositionId;

    @ApiModelProperty("上级职位名称")
    @SaturnColumn(description = "上级职位名称")
    private String parentPositionName;

    @ApiModelProperty("所属组织名称")
    @SaturnColumn(description = "所属组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @SaturnColumn(description = "职位名称")
    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    @SaturnColumn(description = "职位级别名称")
    private String positionLevelName;
}
