package com.biz.crm.nebular.mdm.terminal.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import java.util.List;


/**
 * 终端信息响应vo
 * @author Liao Hua
 * @date 2020/9/3 10:31 上午
 */
@Data
@ApiModel(value = "MdmTerminalRespVo")
@SaturnDomain(value = "mdmterminalrespvo")
@SaturnEntity(name = "MdmTerminalRespVo", description = "终端信息响应vo")
public class MdmTerminalRespVo extends CrmBaseVo {

  @ApiModelProperty("终端编码")
  @SaturnColumn(description = "终端编码")
  private String terminalCode;

  @ApiModelProperty("终端名称")
  @SaturnColumn(description = "终端名称")
  private String terminalName;

  @ApiModelProperty("终端类型")
  @SaturnColumn(description = "终端类型")
  private String terminalType;

  @ApiModelProperty("终端类型名称")
  @SaturnColumn(description = "终端类型名称")
  @CrmDict(typeCode = "terminal_type",dictCodeField = "terminalType")
  private String terminalTypeName;

  @ApiModelProperty("所属组织编码")
  @SaturnColumn(description = "所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  @SaturnColumn(description = "所属组织")
  private String orgName;

  @ApiModelProperty("客户组织编码")
  @SaturnColumn(description = "客户组织编码")
  private String customerOrgCode;

  @ApiModelProperty("客户组织名称")
  @SaturnColumn(description = "客户组织")
  private String customerOrgName;

  @ApiModelProperty("渠道")
  @SaturnColumn(description = "渠道")
  private String channel;

  @ApiModelProperty("渠道名称")
  @SaturnColumn(description = "渠道名称")
  @CrmDict(typeCode = "customer_source",dictCodeField = "channel")
  private String channelName;

  @ApiModelProperty("营业执照法人姓名")
  @SaturnColumn(description = "营业执照法人姓名")
  private String licensePersonName;

  @ApiModelProperty("营业执照注册号")
  @SaturnColumn(description = "营业执照注册号")
  private String licenseRegisterNumber;

  @ApiModelProperty("营业执照企业名称")
  @SaturnColumn(description = "营业执照企业名称")
  private String licenseFirmName;

  @ApiModelProperty("终端地址")
  @SaturnColumn(description = "终端地址")
  private String terminalAddress;

  @ApiModelProperty("省编码")
  private String provinceCode;

  @ApiModelProperty("市编码")
  private String cityCode;

  @ApiModelProperty("区编码")
  private String districtCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  @ApiModelProperty("市名称")
  private String cityName;

  @ApiModelProperty("区名称")
  private String districtName;

  @ApiModelProperty("店招照片")
  @SaturnColumn(description = "店招照片")
  private String shopImagePath;

  @ApiModelProperty("营业执照照片")
  @SaturnColumn(description = "营业执照照片")
  private String licenseImagePath;

  @ApiModelProperty("联系人列表")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
  @SaturnColumn(description = "联系人列表")
  private List<MdmTerminalContactRespVo> mdmTerminalContactRespVos;

  @ApiModelProperty("供应关系")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
  @SaturnColumn(description = "供应关系")
  private List<MdmTerminalSupplyRespVo> mdmTerminalSupplyRespVos;
}
