package com.biz.crm.nebular.sfa.worksignrule.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
/**
 * 考勤规则-打卡人员 请求vo
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignPersonnelReqVo", description = "考勤规则-打卡人员 ")
public class SfaWorkSignPersonnelReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("组织编码 组织编码")
    private String wspCode;

    @ApiModelProperty("组织名称 组织名称")
    private String wspName;

    @ApiModelProperty("类型 类型(10:当前组织;20:当前组织及下级组织)")
    private String wspType;

    @ApiModelProperty("范围类型 范围类型(1:包含;2:非包含;)")
    private String rangeType;

    @ApiModelProperty("考勤规则编码 考勤规则编码")
    private String ruleCode;

    @ApiModelProperty("考勤规则编码集合 考勤规则编码集合")
    private List<String> ruleCodes;

    private String ext1 = StringUtils.EMPTY;

    private String ext2 = StringUtils.EMPTY;

    private String ext3 = StringUtils.EMPTY;

    private String ext4 = StringUtils.EMPTY;

    private String ext5 = StringUtils.EMPTY;

    private String ext6 = StringUtils.EMPTY;

    private String ext7 = StringUtils.EMPTY;

    private String ext8 = StringUtils.EMPTY;

    private String ext9 = StringUtils.EMPTY;

    private String ext10 = StringUtils.EMPTY;

}