package com.biz.crm.nebular.sfa.worksignrule.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
/**
 * 考勤规则-打卡地点 请求vo
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignPlaceReqVo", description = "考勤规则-打卡地点 ")
public class SfaWorkSignPlaceReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("序号 序号")
    private String wspNo;

    @ApiModelProperty("打卡地点名称 打卡地点名称")
    private String placeName;

    @ApiModelProperty("地点经度 地点经度")
    private String placeLngin;

    @ApiModelProperty("地点纬度 地点纬度")
    private String placeLatin;

    @ApiModelProperty("打卡范围 打卡范围(100:100米,300:300米,500:500米)")
    private String placeRange;

    @ApiModelProperty("打卡类型 打卡类型(1:上班签到;2:下班签退)")
    private String workSignType;

    @ApiModelProperty("考勤规则编码 考勤规则编码")
    private String ruleCode;

    @ApiModelProperty("考勤规则编码集合 考勤规则编码集合")
    private List<String> ruleCodes;

    private String ext1 = StringUtils.EMPTY;

    private String ext2 = StringUtils.EMPTY;

    private String ext3 = StringUtils.EMPTY;

    private String ext4 = StringUtils.EMPTY;

    private String ext5 = StringUtils.EMPTY;

    private String ext6 = StringUtils.EMPTY;

    private String ext7 = StringUtils.EMPTY;

    private String ext8 = StringUtils.EMPTY;

    private String ext9 = StringUtils.EMPTY;

    private String ext10 = StringUtils.EMPTY;

}