package com.biz.crm.nebular.sfa.worksignrule.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 考勤规则-打卡地点 返回vo
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤规则-打卡地点 ")
@SaturnEntity(name = "SfaWorkSignPlaceRespVo", description = "考勤规则-打卡地点 ")
public class SfaWorkSignPlaceRespVo extends CrmBaseVo {

    @ApiModelProperty("序号 序号")
    @SaturnColumn(description = "序号 序号")
    private String wspNo;

    @ApiModelProperty("打卡地点名称 打卡地点名称")
    @SaturnColumn(description = "打卡地点名称 打卡地点名称")
    private String placeName;

    @ApiModelProperty("地点经度 地点经度")
    @SaturnColumn(description = "地点经度 地点经度")
    private String placeLngin;

    @ApiModelProperty("地点纬度 地点纬度")
    @SaturnColumn(description = "地点纬度 地点纬度")
    private String placeLatin;

    @ApiModelProperty("打卡范围 打卡范围(100:100米,300:300米,500:500米)")
    @SaturnColumn(description = "打卡范围 打卡范围(100:100米,300:300米,500:500米)")
    private String placeRange;

    @ApiModelProperty("打卡类型 打卡类型(1:上班签到;2:下班签退)")
    @SaturnColumn(description = "打卡类型 打卡类型(1:上班签到;2:下班签退)")
    private String workSignType;

    @ApiModelProperty("考勤规则编码 考勤规则编码")
    @SaturnColumn(description = "考勤规则编码 考勤规则编码")
    private String ruleCode;

    @ApiModelProperty("考勤规则编码集合 考勤规则编码集合")
    @SaturnColumn(description = "考勤规则编码集合 考勤规则编码集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> ruleCodes;

    private String ext1 = StringUtils.EMPTY;

    private String ext2 = StringUtils.EMPTY;

    private String ext3 = StringUtils.EMPTY;

    private String ext4 = StringUtils.EMPTY;

    private String ext5 = StringUtils.EMPTY;

    private String ext6 = StringUtils.EMPTY;

    private String ext7 = StringUtils.EMPTY;

    private String ext8 = StringUtils.EMPTY;

    private String ext9 = StringUtils.EMPTY;

    private String ext10 = StringUtils.EMPTY;

}