package com.biz.crm.nebular.tpm.act.resp;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动明细信息表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动明细信息表;")
@SaturnEntity(name = "TpmActDetailRespVo", description = "活动明细信息表;")
public class TpmActDetailRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    @SaturnColumn(description = "活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动大类编码")
    @SaturnColumn(description = "活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    @SaturnColumn(description = "活动大类名称")
    private String categoriesName;

    @ApiModelProperty("关联预算科目(科目编码)")
    @SaturnColumn(description = "预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("企业组织编码")
    @SaturnColumn(description = "企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    @SaturnColumn(description = "企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("客户所属组织编码")
    @SaturnColumn(description = "客户所属组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户所属组织名称")
    @SaturnColumn(description = "客户所属组织名称")
    private String customerOrgName;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("物料编码")
    @SaturnColumn(description = "物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    @SaturnColumn(description = "物料名称")
    private String materialName;

    @ApiModelProperty("物料价格")
    @SaturnColumn(description = "物料价格")
    private BigDecimal materialPrice;

    @ApiModelProperty("物料单位(字典)")
    @SaturnColumn(description = "物料单位(字典)")
    private String materialUnit;

    @ApiModelProperty("物料单位名称")
    @SaturnColumn(description = "物料单位名称")
    private String materialUnitName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private Long num;

    @ApiModelProperty("最小包装量")
    @SaturnColumn(description = "最小包装量")
    private Long miniPackNum;

    @ApiModelProperty("门店编码")
    @SaturnColumn(description = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @SaturnColumn(description = "门店名称")
    private String terminalName;

    @ApiModelProperty("预估销售额")
    @SaturnColumn(description = "预估销售额")
    private BigDecimal forecastSalesAmount;

    @ApiModelProperty("费用申请金额")
    @SaturnColumn(description = "费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("支付方式(字典编码)")
    @SaturnColumn(description = "支付方式(字典编码)")
    private String payType;

    @ApiModelProperty("支付方式名称")
    @SaturnColumn(description = "支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型(字典编码)")
    @SaturnColumn(description = "支付方式类型(字典编码)")
    private String payTypeType;

    @ApiModelProperty("支付方式列表(字典编码)")
    @SaturnColumn(description = "支付方式列表(字典编码)")
    private String payTypeList;

    @ApiModelProperty("支付方式(集合的json,字典)")
    @SaturnColumn(description = "支付方式")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<DictItemVo> payTypes;

    @ApiModelProperty("支付方式集合的json字符串")
    @SaturnColumn(description = "支付方式集合的json字符串")
    private String payTypesJsonStr;

    @ApiModelProperty("币种")
    @SaturnColumn(description = "币种")
    private String currencyType;

    @ApiModelProperty("币种名称")
    @SaturnColumn(description = "币种名称")
    private String currencyTypeName;

    @ApiModelProperty("价格类型")
    @SaturnColumn(description = "价格类型")
    private String priceType;

    @ApiModelProperty("活动细类发布需求(部门,终端,客户),字典")
    @SaturnColumn(description = "活动细类发布需求(部门,终端,客户),字典")
    private String activityReleaseNeed;

    @ApiModelProperty("是否完全核销")
    @SaturnColumn(description = "是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否核销")
    @SaturnColumn(description = "是否核销")
    private String isAudit;

    @ApiModelProperty("核销截止日期")
    @SaturnColumn(description = "核销截止日期")
    private String allowAuditEndDate;

    @ApiModelProperty("核销截止时间")
    @SaturnColumn(description = "核销截止时间")
    private String allowAuditEndDateSecond;

    @ApiModelProperty("超额核销比例")
    @SaturnColumn(description = "超额核销比例")
    private BigDecimal extraAuditRatio;

    @ApiModelProperty("已核销金额")
    @SaturnColumn(description = "已核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("年月")
    @SaturnColumn(description = "年月")
    private String actDetailYearMonth;

    @ApiModelProperty("费率")
    @SaturnColumn(description = "费率")
    private BigDecimal feeRate;

    @ApiModelProperty("政策编码")
    @SaturnColumn(description = "政策编码")
    private String policyCode;

    @ApiModelProperty("政策名称")
    @SaturnColumn(description = "政策名称")
    private String policyName;

    @ApiModelProperty("终端售价")
    @SaturnColumn(description = "终端售价")
    private BigDecimal terminalPrice;

    @ApiModelProperty("未税价")
    @SaturnColumn(description = "未税价")
    private BigDecimal ninTaxPrice;

    @ApiModelProperty("是否允许多次核销(Y/N)")
    @SaturnColumn(description = "是否允许多次核销(Y/N)")
    private String isAllowRepeatAudit;

    @ApiModelProperty("排序值(记录新增时的顺序值,修改需要重排序)")
    @SaturnColumn(description = "排序值(记录新增时的顺序值,修改需要重排序)")
    private Integer sortNum;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;



    @ApiModelProperty("已申请预付总金额(活动预付专用字段)")
    @SaturnColumn(description = "已申请预付总金额")
    private BigDecimal alreadyApplyAdvanceTotalAmount;
}