package com.biz.crm.nebular.tpm.act.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动信息主表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动信息主表;")
@SaturnEntity(name = "TpmActRespVo", description = "活动信息主表;")
public class TpmActRespVo extends CrmExtVo {
    @ApiModelProperty("活动类型(字典)")
    @SaturnColumn(description = "活动类型(字典)")
    private String actType;

    @ApiModelProperty("活动类型名称")
    @SaturnColumn(description = "活动类型")
    private String actTypeName;

    @ApiModelProperty("流程编号")
    @SaturnColumn(description = "流程编号")
    private String processCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("审批状态(字典)")
    @SaturnColumn(description = "审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("审批状态名称")
    @SaturnColumn(description = "审批状态名称")
    private String approveStatusName;

    @ApiModelProperty("是否完全核销")
    @SaturnColumn(description = "是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否核销")
    @SaturnColumn(description = "是否核销")
    private String isAudit;

    @ApiModelProperty("活动概述")
    @SaturnColumn(description = "活动概述")
    private String actDesc;

    @ApiModelProperty("开始日期")
    @SaturnColumn(description = "开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    @SaturnColumn(description = "结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;

    @ApiModelProperty("工作流key")
    @SaturnColumn(description = "工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    @SaturnColumn(description = "工作流名称")
    private String workFlowName;

    @ApiModelProperty("申请金额")
    @SaturnColumn(description = "申请金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("审批附件")
    @SaturnColumn(description = "审批附件")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmActFileRespVo> fileList;

    @ApiModelProperty("预算信息")
    @SaturnColumn(description = "预算信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmActBudgetRespVo> budgetVos;

    @ApiModelProperty("明细信息")
    @SaturnColumn(description = "明细信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmActDetailRespVo> detailVos;

    @ApiModelProperty("分摊信息")
    @SaturnColumn(description = "分摊信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TmpActFeeShareRespVo> feeShareVos;

    @ApiModelProperty("编辑查看时,费用预算的集合数据")
    @SaturnColumn(description = "分摊信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmFeeBudgetControlRespVo> editBudgetVos;

}