package com.biz.crm.util;

import lombok.Getter;

public interface CommonConstant {
	/* 异常消息提示 */
    public static final Integer SC_INTERNAL_SERVER_ERROR_500 = 500;
    /* 没有权限登录 */
    public static final Integer NO_LOGIN_401 = 401;
    /* 返回成功 */
    public static final Integer SC_OK_200 = 200;


    /**
     * 字典标记
     *  @author: luoqi
     *  @Date: 2020-10-20 14:50
     *  @version: V1.0
     *  @Description:
     */
    public interface Dict {}

    /**
     * 字典对象
     *  @author: luoqi
     *  @Date: 2020-10-20 14:51
     *  @version: V1.0
     *  @Description:
     */
    @Getter
    public static class DictItem {
        private String itemName;
        private String itemCode;
        private DictItem(String itemCode, String itemName ) {
            this.itemName = itemName;
            this.itemCode = itemCode;
        }
    }




    /** GLOBAL 通用区 **/
    public static class GLOBAL {
        /** yesOrNo**/
        public static class YesOrNo implements CommonConstant.Dict {
            public static final String DICT_CODE = "yesOrNo";
            /** Y */
            public static final CommonConstant.DictItem Y = new CommonConstant.DictItem("Y", "是");
            /** N */
            public static final CommonConstant.DictItem N = new CommonConstant.DictItem("N", "否");
        }
    }



    /** DMS 区 **/
    public static class DMS {

        /** 促销范围类型**/
        public static class PromotionPolicyScopeType implements CommonConstant.Dict {
            public static final String DICT_CODE = "promotionPolicyScopeType";
            /** 渠道 */
            public static final CommonConstant.DictItem CHANNEL = new CommonConstant.DictItem("channel", "渠道");
            /** 组织 */
            public static final CommonConstant.DictItem ORG = new CommonConstant.DictItem("org", "组织");
            /** 客户 */
            public static final CommonConstant.DictItem CUST = new CommonConstant.DictItem("cust", "客户");
        }


        /** 促销规则类型**/
        public static class PromotionPolicyRuleType implements CommonConstant.Dict {
            public static final String DICT_CODE = "promotionPolicyRuleType";
            /** 条件规则 */
            public static final CommonConstant.DictItem CONDITION = new CommonConstant.DictItem("condition", "条件规则");
            /** 限量规则 */
            public static final CommonConstant.DictItem LIMITED = new CommonConstant.DictItem("limited", "限量规则");
            /** 计算规则 */
            public static final CommonConstant.DictItem CALCULATE = new CommonConstant.DictItem("calculate", "计算规则");
        }


    }



    /** TPM 区 **/
    public static class TPM {

    }



    /** SAF 区 **/
    public static class SAF {

    }

}
