package com.biz.crm.nebular.activiti.start.req;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "OptRecordReqVO", description = "流程审批记录请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class OptRecordReqVO extends PageVo {

    @ApiModelProperty(value = "流程实例ID", required = true)
    private String processInstanceId;

    @ApiModelProperty(value = "查询用户编码(非必传)")
    private String userCode;

    @ApiModelProperty(value = "表单单号(非必传)")
    private String formNo;

    @ApiModelProperty(value = "业务单据类型")
    private String costType;

    @ApiModelProperty(value = "业务单据来源系统")
    private String formType;

    @ApiModelProperty(value = "流程版本号")
    private String processVersionKey;

    @ApiModelProperty(value = "岗位编码")
    private String positionCode;

    @ApiModelProperty(value = "流程唯一编号")
    private String processNo;

    @ApiModelProperty(value = "附件列表")
    private List<TaActFileRespVo> fileList;
}
