package com.biz.crm.nebular.activiti.task.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailKeyTargetVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author jerry7
 * @date 2021-04-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "流程摘要响应vo")
@CrmColumnResolve
public class ProcessSummaryRspVO implements Serializable {

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "流程名称")
    private String processKey;

    @ApiModelProperty(value = "流程编号")
    private String processNo;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "发起人名称")
    private String applierName;

    @ApiModelProperty(value = "流程发起时间")
    private String createTime;

    @ApiModelProperty("关键指标列表")
    private List<TaActTargetRespVo> taActTargetRespVos;

    @ApiModelProperty("关键指标集合的json字符串")
    private String keyTargetListJson;

    @ApiModelProperty("关键指标集合")
    private List<Object>  keyTargetList= Lists.newArrayList();

    @ApiModelProperty(value = "发起人职位名称")
    private String applierPositionName;

    @ApiModelProperty(value = "流程提交文件")
    List<TaActFileRespVo> processFiles;

    @ApiModelProperty(value = "流程名称")
    private String processName;
}
