package com.biz.crm.nebular.activiti.vo;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.nebular.activiti.vo
 * @Description: TODO
 * @date 2021/4/23 下午1:26
 */
@Data
@ApiModel(value = "当前任务CurrentTaskVo")
@CrmColumnResolve
public class CurrentTaskVo extends CrmExtTenVo {

    @ApiModelProperty(value = "流程实例id")
    private String processInstanceId;

    @ApiModelProperty(value = "流程编号")
    private String crmProcessInstanceId;
    @ApiModelProperty(value = "表单id")
    private String businessId;

    @ApiModelProperty(value = "表单编码")
    private String businessNo;

    @ApiModelProperty(value = "流程key")
    private String processKey; //
    @ApiModelProperty(value = "流程名称")
    private String processName; //
    @ApiModelProperty(value = "表单名称")
    private String processTitle;
    @ApiModelProperty(value = "发起人职位编码")
    private String commitPos;
    @ApiModelProperty(value = "发起人职位名称")
    private String commitPosName;

    @ApiModelProperty(value = "发起人编码")
    private String commitCode;


    @ApiModelProperty(value = "发起人名字")
    private String commitName;

    @ApiModelProperty(value = "发起人组织编码")
    private String commitByOrg;

    @ApiModelProperty(value = "发起人组织名称")
    private String commitByOrgName;

    @ApiModelProperty(value = "流程发起时间")
    private String commitDate;
    @ApiModelProperty(value = "上一节点时间")
    private String beforPassDate;
    @ApiModelProperty(value = "流程状态 数据字典bpm_status")
    private String bpmStatus;

    @ApiModelProperty(value = "流程状态名称 数据字典bpm_status")
    private String bpmStatusName;

    @ApiModelProperty(value = "任务编号")
    private String taskId;
    @ApiModelProperty(value = "当前任务")
    private String taskName;

    @ApiModelProperty(value = "当前待处理人职位编码")
    private String currentTaskPositionCode;

    @ApiModelProperty(value = "当前待处理人职位名称")
    private String currentTaskPositionName;

    @ApiModelProperty(value = "当前待处理人名称")
    private String currentTaskUserName;

    @ApiModelProperty(value = "当前待处理人编码")
    private String currentTaskUserCode;

    @ApiModelProperty(value = "沟通任务id")
    private String communicateId;

    @ApiModelProperty(value = "沟通任务内容")
    private String communicateContent;

    //枚举 ProcessInstanceStatusEnum
    @ApiModelProperty(value = "流程实例状态(启用,禁用,暂停,结束)编码")
    private String processInstanceStatus;
}
