package com.biz.crm.nebular.activiti.vo;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.activiti.vo
 * @ClassName ProcessInstanceQueryReqVo
 * @Author HuangLong
 * @Date 2021/5/12 17:30
 * @Description 流程实例查询请求vo
 */
@Data
public class ProcessInstanceQueryRespVo extends CrmExtTenVo {

    //业务流程编号
    @ApiModelProperty(value = "业务表单编号")
    private String crmProcessInstanceId;
    //工作流编号
    @ApiModelProperty(value = "流程实例id")
    private String processInstanceId;
    //枚举 ActivitiOperateTypeEnum
    @ApiModelProperty(value = "审批状态编码")
    private String bpmStatus;

    @ApiModelProperty(value = "审批状态名称")
    private String bpmStatusName;

    //枚举 ProcessInstanceStatusEnum
    @ApiModelProperty(value = "流程实例状态(启用,禁用,暂停,结束)编码")
    private String processInstanceStatus;

    @ApiModelProperty(value = "流程实例状态(启用,禁用,暂停,结束)名称")
    private String processInstanceStatusName;

    @ApiModelProperty(value = "业务表单id")
    private String businessId;

    @ApiModelProperty(value = "业务表单编码")
    private String businessNo;

    @ApiModelProperty(value = "流程key")
    private String processKey;

    @ApiModelProperty(value = "流程名称")
    private String processName;

    @ApiModelProperty(value = "标题")
    private String processTitle;

    @ApiModelProperty(value = "发起人职位编码")
    private String commitPos;

    @ApiModelProperty(value = "发起人职位名称")
    private String commitPosName;

    @ApiModelProperty(value = "发起人编码")
    private String commitCode;

    @ApiModelProperty(value = "发起人名称")
    private String commitName;

    @ApiModelProperty(value = "发起人组织编码")
    private String commitByOrg;

    @ApiModelProperty(value = "发起人组织名称")
    private String commitByOrgName;

    @ApiModelProperty(value = "流程发起时间")
    private String commitDate;

    @ApiModelProperty(value = "上一节点时间")
    private String beforPassDate;

    @ApiModelProperty(value = "总耗时")
    private String commitElapsedTime;

    @ApiModelProperty(value = "关键指标集合的json字符串")
    private String keyTargetListJson;

    @ApiModelProperty(value = "菜单编码")
    private String menuCode;

    @ApiModelProperty(value = "回调feign")
    private String callBackFeign;

    @ApiModelProperty(value = "流程版本KEY(取自ACT_RE_PROCDEF表的id)")
    private String processVersionKey;

    @ApiModelProperty(value = "当前待处理人职位编码")
    private String currentTaskPositionCode;

    @ApiModelProperty(value = "当前待处理人职位名称")
    private String currentTaskPositionName;

    @ApiModelProperty(value = "当前待处理人名称")
    private String currentTaskUserName;

    @ApiModelProperty(value = "当前待处理人编码")
    private String currentTaskUserCode;

    @ApiModelProperty(value = "流程结束时间")
    private String processEndDate;

    @ApiModelProperty(value = "业务流程类型")
    private String costType;

    @ApiModelProperty(value = "业务来源系统")
    private String formType;


    @ApiModelProperty(value = "处理时间(已办)")
    private String doneDate;

    @ApiModelProperty(value = "已办处理意见")
    private String doneRemarks;

    @ApiModelProperty(value = "已办操作类型编码")
    private String doneOperateType;

    @ApiModelProperty(value = "已办操作类型名称")
    private String doneOperateTypeName;



}
