package com.biz.crm.nebular.dms.complaints;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "投诉建议文件的vo")
@SaturnEntity(name = "ComplaintsReplyVo", description = "投诉建议文件")
@SaturnDomain(value = "complaintsreply")
public class ComplaintsReplyVo extends CrmExtTenVo {

    @ApiModelProperty(value = "投诉建议id")
    @SaturnColumn(description = "投诉建议id")
    private String complaintsId;

    @ApiModelProperty(value = "投诉内容")
    @SaturnColumn(description = "投诉内容")
    private String content;

    @ApiModelProperty(value = "回复人")
    @SaturnColumn(description = "回复人")
    private String submitter;

    @ApiModelProperty(value = "回复人类型(0 厂家，1 客户)")
    @SaturnColumn(description = "回复人类型")
    private String submitterType;
}
