package com.biz.crm.nebular.dms.minbuynumofproduct;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;

/**
 * 起订量vo
 *
 * @Author: huojia
 * @DateTime: 2021/1/25 17:05
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "api通过客户及其组织查询产品的最小起订量的vo")
public class FindByCusCodeAndProductCodesToCusReq extends CrmExtVo {

    @ApiModelProperty(value = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户组织编码")
    private String orgCode;

    @ApiModelProperty(value = "要查询的产品编码集合")
    private ArrayList<String> productCodes = new ArrayList<>();

    public static FindByCusCodeAndProductCodesToCusReq newInstance(String cusCode, String orgCode, ArrayList<String> productCodes){
        FindByCusCodeAndProductCodesToCusReq req = new FindByCusCodeAndProductCodesToCusReq();
        req.setCusCode(cusCode);
        req.setOrgCode(orgCode);
        req.setProductCodes(productCodes);
        return req;
    }
}