package com.biz.crm.nebular.dms.promotion.policy.resp;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;
import lombok.experimental.Accessors;

public class PromotionPolicyInfoDataVo extends PromotionPolicyInfoVo {
    /**
     * 政策赠送量计算结果
     */
    @Getter
    @Setter
    @ApiModelProperty(value = "政策赠送量计算结果")
    private CalculateRuleResponse calculateRuleResponse;

    /**
     * 已使用政策活动预算
     */
    @Getter
    @Setter
    @ApiModelProperty(value = "已使用政策活动预算")
    private BigDecimal usedTotal;
    /**
     * 命中该政策的明细记录
     */
    @Getter
    private List<HitDetail> hitDetails = Lists.newArrayList();

    /**
     * 添加命中该政策的明细记录
     * @param key
     * @param value
     */
    public void addHitDetail(String key, String value){
        hitDetails.add(new HitDetail(key, value));
    }
    public void addHitDetail(HitDetail detail){
        if(null == detail){
            return;
        }
        hitDetails.add(detail);
    }

    /**
     * 命中该政策的明细记录
     *  @author: luoqi
     *  @Date: 2020-12-28 15:50
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @AllArgsConstructor
    public static class HitDetail{
        public HitDetail(){}
        private String key;
        private String value;
    }
}
