package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 货补费用池使用请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsUseReqVo", description = "货补费用池使用请求VO")
public class FeePoolGoodsUseReqVo {

    @ApiModelProperty("使用类型，不填表示默认")
    private String useType;

    @ApiModelProperty("（货补费用池专用、二选一）货补费用池按照（费用池编号+商品）使用")
    private List<FeePoolGoodsUseByPoolProductItemReqVo> goodsUseByPoolProductList;

    @ApiModelProperty("（货补费用池专用、二选一）货补费用池按照（产品层级）使用")
    private List<FeePoolGoodsUseByProductLevelItemReqVo> goodsUseByProductLevelList;

}