package com.biz.crm.nebular.fee.pool.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池金额查询根据用途分组返回VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池金额查询根据用途分组返回VO")
public class FeePoolAmountGroupByUseTypeRespVo {

    @ApiModelProperty("用途（字典编码）")
    private String useType;

    @ApiModelProperty("用途（字典名称）")
    private String useTypeName;

    @ApiModelProperty("客户折扣费用可用余额")
    private BigDecimal amount;

}