package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 货补费用池商品组返回VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "货补费用池商品组返回VO")
@CrmColumnResolve
public class FeePoolGoodsProductGroupRespVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码(集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称(集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

    @ApiModelProperty("总金额/数量")
    private BigDecimal totalAmount;

    @ApiModelProperty("已冻结金额/数量")
    private BigDecimal freezeAmount;

    @ApiModelProperty("占用金额/数量")
    private BigDecimal occupyAmount;

    @ApiModelProperty("已使用金额/数量")
    private BigDecimal hasUseAmount;

    @ApiModelProperty("剩余可使用金额/数量")
    private BigDecimal usableAmount;

    @ApiModelProperty("商品明细")
    private List<FeePoolGoodsProductRespVo> productList;
}