package com.biz.crm.nebular.job.resp;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author jerry7
 * @date 2020-12-11 15:32:21
 **/
@Data
@ApiModel(value = "XxlJobLogReqVo", description = "任务调度日志查询")
public class XxlJobLogRespVo {

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("执行器ID")
    private String jobGroup;

    @ApiModelProperty("任务ID")
    private String jobId;

    @ApiModelProperty("执行器地址")
    private String executorAddress;

    @ApiModelProperty("执行器Handler")
    private String executorHandler;

    @ApiModelProperty("执行参数")
    private String executorParam;

    @ApiModelProperty("执行共享参数")
    private String executorShardingParam;

    @ApiModelProperty("执行失败重试次数")
    private int executorFailRetryCount;

    @ApiModelProperty("调度时间")
    private Date triggerTime;

    @ApiModelProperty("调度回码")
    private int triggerCode;

    @ApiModelProperty("调度信息")
    private String triggerMsg;

    @ApiModelProperty("执行时间")
    private Date handleTime;

    @ApiModelProperty("执行回码")
    private int handleCode;

    @ApiModelProperty("执行消息")
    private String handleMsg;

    @ApiModelProperty("报警状态")
    private int alarmStatus;

    @ApiModelProperty("日志状态 1-成功，2-失败，3-进行中，-1全部")
    private String logStatus;

    @ApiModelProperty("调度结果")
    private String triggerResult;

    @ApiModelProperty("执行结果")
    private String handleResult;

}
