package com.biz.crm.nebular.kms.confadmin.base;

import com.google.common.base.Enums;
import lombok.Getter;

/**
 * @author yangming
 * @date 2019/6/18 0018
 *
 * 启用、禁用状态
 */
@Getter
public enum ComomStatus {
    /**
     * 启用
     */
    ENABLE(0, "启用"),
    /**
     * 禁用
     */
    DISABLE(1, "禁用"),

    /**
     * 是
     */
    YES(2,"是"),
    /**
     * 否
     */
    NO(3,"否");

    private Integer value;
    private String description;


    ComomStatus(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static ComomStatus getIfPresent(String name) {
        return Enums.getIfPresent(ComomStatus.class, name).orNull();
    }

}
