package com.biz.crm.nebular.kms.confadmin.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商超信息请求vo
 *
 * @author Gavin
 * @date 2021-05-06 13:51:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsDirectSystemReqVo", description = "商超信息")
public class KmsDirectSystemReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -3579143820231330537L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("商超url地址")
    private String vendorSystemUrl;

    @ApiModelProperty("支持单据类型集合 数据字典：kms_order_type")
    private List<KmsDirectOrderTypeReqVo> orderTypeVos;
}