package com.biz.crm.nebular.kms.confadmin.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商超单据抓取方式请求vo
 *
 * @author Gavin
 * @date 2021-05-06 15:12:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsDirectThreadReqVo", description = "商超单据抓取方式")
public class KmsDirectThreadReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 6175975048899394495L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("单据类型")
    private String orderType;

    @ApiModelProperty("单据下载方式（0_单线程，1_多线程）数据字典：kms_order_download_way")
    private Integer orderDownloadWay;

    @ApiModelProperty("原始文件格式（0_EXCEL,1_PDF,2_截屏）数据字典：kms_file_classify")
    private Integer fileClassify;

    @ApiModelProperty("文件下载方式（0_单线程，1_多线程）数据字典：kms_order_download_way")
    private Integer fileDownloadWay;


}