package com.biz.crm.nebular.kms.confadmin.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 抓单参数（运营管理后台）
 * </p>
 *
 * @author yangming
 * @since 2019-07-02
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "抓单参数RespVo")
public class BsGrabInterfaceParamRespVo implements Serializable {

    private static final long serialVersionUID = 4554727261825252828L;

    @ApiModelProperty(value = "参数id")
    private String fieldId;

    @ApiModelProperty(value = "商超ID")
    private String directId;

    @ApiModelProperty(value = "单据类型")
    private String orderType;

    /**
     * 属性
     */
    @ApiModelProperty(value = "属性")
    private String fieldEn;

    /**
     * 参数文本
     */
    @ApiModelProperty(value = "参数文本")
    private String fieldCn;

    /**
     * 控件类型
     */
    @ApiModelProperty(value = "控件类型")
    private String fieldClassify;

    /**
     * 参数类型
     */
    @ApiModelProperty(value = "参数类型")
    private String paramClassify;

    /**
     * 提示文字
     */
    @ApiModelProperty(value = "提示文字")
    private String promptText;

    @ApiModelProperty("字段是否必填(YES/NO)")
    private String isRequired;

    @ApiModelProperty("是否显示（0：显示，1：不显示）")
    private String isShow;

    @ApiModelProperty("字段排序")
    private Integer sortIndex;

    @ApiModelProperty("查询条件（0：不是筛选字段，1：是筛选字段）")
    private String isScreen;

    @ApiModelProperty("下拉选项名称")
    private String optionName;

    /**
     * 已设置值
     */
    @ApiModelProperty(value = "已设置值")
    private String fieldValue;

    /**
     * 下拉单选选项列表
     */
    @ApiModelProperty(value = "下拉单选选项列表")
    private List<BsGrabInterfaceParamOptionRespVo> options;

    /**
     * 子参数列表
     */
    @ApiModelProperty(value = "子参数列表")
    private List<BsGrabInterfaceSubParamOptionRespVo> subOptions;
}
