package com.biz.crm.nebular.kms.finance.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.kms.finance.resp
 * @ClassName KmsAuditFormExportRespVo
 * @Author Gavin
 * @Date 2021/7/9 上午10:21
 * @Description 稽核导出Vo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "稽核数据")
@CrmColumnResolve
public class KmsAuditFormExportRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -7122990610888703800L;

    @ApiModelProperty("稽核单号")
    private String auditNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("公司代码")
    private String bukrs;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("所属公司")
    private String ownedCompany;

    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("匹配结果（待匹配/无差异/有差异）")
    private String auditResult;

    @ApiModelProperty("sap过账日期")
    private String sapPostingDate;

    @ApiModelProperty("sap过账日期")
    private String sapPostingDateExport;

    @ApiModelProperty("送达方编号")
    private String storeCode;

    @ApiModelProperty("送达方名称")
    private String storeName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("SAP物料号")
    private String sapMaterielCode;

    @ApiModelProperty("SAP物料名称")
    private String sapMaterielName;

    @ApiModelProperty("总SAP数量")
    private BigDecimal sapQuantity;

    @ApiModelProperty("总验收数量")
    private BigDecimal acceptanceQuantity;

    @ApiModelProperty("总数量差异")
    private BigDecimal compareQuantity;

    @ApiModelProperty("SAP总金额（不含税）")
    private BigDecimal sapAmountNot;

    @ApiModelProperty("验收总金额（不含税）")
    private BigDecimal acceptanceAmountNot;

    @ApiModelProperty("总金额差异（不含税）")
    private BigDecimal compareAmountNot;

    @ApiModelProperty("SAP总金额（含税）")
    private BigDecimal sapAmount;

    @ApiModelProperty("验收总金额（含税）")
    private BigDecimal acceptanceAmount;

    @ApiModelProperty("总金额差异（含税）")
    private BigDecimal compareAmount;

    @ApiModelProperty("配送商")
    private String distributor;

    @ApiModelProperty("含税单价")
    private BigDecimal danjia;

    @ApiModelProperty("验收单含税单价")
    private BigDecimal acceptanceDanJia;

    @ApiModelProperty("完成日期")
    private String completionDate;

    @ApiModelProperty("完成人")
    private String rinisher;

    @ApiModelProperty("容差规则（正_Z/负_F/上下浮动_UD）")
    private String auditRule;

    @ApiModelProperty("价格允差")
    private String differencePrice;

    @ApiModelProperty("对账匹配阈值（天数）")
    private String timeOfDay;

    @ApiModelProperty("商品类型")
    private String productType;

    @ApiModelProperty("稽核状态(待确认/已确认)")
    private String auditStatus;

    @ApiModelProperty("是否稽核yes/no")
    private String isAudit;

    @ApiModelProperty("SAP发票单号")
    private String sapNo;

    @ApiModelProperty("SAP交货单号")
    private String vgbel;

    @ApiModelProperty("SAP过账日期")
    private String itemSapPostingDate;

    @ApiModelProperty("送达方编号")
    private String itemSapStoreCode;

    @ApiModelProperty("SAP送达方名称")
    private String itemSapStoreName;

    @ApiModelProperty("SAP物料号")
    private String itemSapMaterielCode;

    @ApiModelProperty("SAP物料名称")
    private String itemSapMaterielName;

    @ApiModelProperty("SAP商品类型")
    private String itemSapProductType;

    @ApiModelProperty("SAP数量")
    private String itemSapQuantity;

    @ApiModelProperty("SAP总金额（不含税）")
    private String itemSapAmountNot;

    @ApiModelProperty("SAP总金额（含税）")
    private String itemSapAmount;

    @ApiModelProperty("SAP配送商")
    private String itemSapDistributor;

    @ApiModelProperty("SAP送达方编码")
    private String itemSapKunnr;

    @ApiModelProperty("SAP送达方名称")
    private String itemSapKunnrname;

    @ApiModelProperty("SAP售达方编码")
    private String itemSapKunag;

    @ApiModelProperty("SAP售达方名称")
    private String itemSapKunagname;

    @ApiModelProperty("SAP发票净值")
    private String netwr;

    @ApiModelProperty("SAP发票税额")
    private String mwsbp;

    @ApiModelProperty("SAP含税总价")
    private String kzwi1;

    @ApiModelProperty("SAP税率")
    private String mwsi1;

    @ApiModelProperty("SAP返利")
    private String kzwi4;

    @ApiModelProperty("SAP折扣")
    private String yk99;

    @ApiModelProperty("SAP物料数量价格折扣 (PR)")
    private String yk04;

    @ApiModelProperty("SAP即时返点%产品组折扣(PR)")
    private String yk11;

    @ApiModelProperty("SAP赠品分摊折扣")
    private String zst2;

    @ApiModelProperty("sap发票创建时间")
    private String erzet;

    @ApiModelProperty("sap订单号")
    private String aubel;

    @ApiModelProperty("sap订单创建时间")
    private String vbakerdat;

    @ApiModelProperty("KMS验收单编码")
    private String itemAccOrderNumber;

    @ApiModelProperty("商超验收单编码")
    private String itemAccKaOrderNumber;

    @ApiModelProperty("验收单商超编码")
    private String itemAccKaCode;

    @ApiModelProperty("验收单商超名称")
    private String itemAccKaName;

    @ApiModelProperty("验收单商超门店/大仓编号")
    private String itemAccKaStoreCode;

    @ApiModelProperty("验收单商超门店/大仓名称")
    private String itemAccKaStoreName;

    @ApiModelProperty("验收单企业门店/大仓编号")
    private String itemAccStoreCode;

    @ApiModelProperty("验收单企业门店/大仓名称")
    private String itemAccStoreName;

    @ApiModelProperty("验收日期")
    private String itemAccAcceptanceDate;

    @ApiModelProperty("验收类型")
    private String itemAccAcceptanceType;

    @ApiModelProperty("验收单金额（含税）")
    private String itemAccAcceptanceAmount;

    @ApiModelProperty("验收单金额（不含税）")
    private String itemAccAcceptanceAmountNot;

    @ApiModelProperty("验收单数量")
    private String itemAccAcceptanceQuantity;

    @ApiModelProperty("业务区域")
    private String itemAccBusinessArea;

    @ApiModelProperty("区域编码")
    private String itemAccAreaCode;

    @ApiModelProperty("区域名称")
    private String itemAccAreaName;

    @ApiModelProperty("验收单售达方名称")
    private String itemAccSoldToPartyName;

    @ApiModelProperty("验收单售达方编码")
    private String itemAccSoldToPartyCode;

    @ApiModelProperty("验收单企业产品编号")
    private String itemAccGoodsCode;

    @ApiModelProperty("验收单企业产品名称")
    private String itemAccGoodsName;

    @ApiModelProperty("验收单商超产品编号")
    private String itemAccKaGoodsCode;

    @ApiModelProperty("验收单商超产品名称")
    private String itemAccKaGoodsName;

    @ApiModelProperty("业务员编码")
    private String pernr;

    @ApiModelProperty("业务员描述")
    private String name4;
}