package com.biz.crm.nebular.kms.orderform.req;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 商超订货单状态流转记录表请求vo
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsOrderStatusRecordReqVo", description = "商超订货单状态流转记录表")
public class KmsOrderStatusRecordReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("抓单生成的订单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("订单当前状态 枚举KmsEnum.OrderStatus")
    private String orderStatus;

}