package com.biz.crm.nebular.kms.orderform.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 商超订货单状态流转记录表返回vo
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超订货单状态流转记录表")
public class KmsOrderStatusRecordRespVo extends CrmExtTenVo {
    @ApiModelProperty("抓单生成的订单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("订单当前状态 枚举KmsEnum.OrderStatus")
    private String orderStatus;

}