package com.biz.crm.nebular.kms.orderform.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.nebular.kms.orderform.resp
 * @ClassName WebServiceFindOrderRespVo
 * @Author Gavin
 * @Date 2021/10/22 下午4:00
 * @Description web service查询商超订货单返还结果
 */
@Data
public class WebServiceFindOrderRespVo implements Serializable {
    private static final long serialVersionUID = -1597370453052765400L;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("订单日期")
    private String orderDate;

    @ApiModelProperty("交货日期")
    private String deliveryDate;

    @ApiModelProperty("经营方式")
    private String runMode;

    @ApiModelProperty("订货单总金额（含税）")
    private String finalOrderAmount;

    @ApiModelProperty("订货单总金额（不含税）")
    private String finalOrderAmountNot;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    @ApiModelProperty("关联ID(企业门店与商超门店表ID)")
    private String storeRelatedId;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("送货地址")
    private String deliveryAddress;

    @ApiModelProperty("送货联系人")
    private String deliveryContact;

    @ApiModelProperty("送货联系人电话")
    private String deliveryContactPhone;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("所属公司")
    private String ownedCompany;

    @ApiModelProperty("订单行详情")
    private List<WebServiceFindOrderItemRespVo> goodsVos;

}